/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei.transfer;

import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.containers.WindowCrafting;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.transfer.AbstractTeachingGuiHandler;
import com.minecolonies.coremod.network.messages.server.TransferRecipeCraftingTeachingMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CraftingGuiHandler
extends AbstractTeachingGuiHandler<WindowCrafting> {
    public CraftingGuiHandler(@NotNull List<JobBasedRecipeCategory<?>> categories) {
        super(categories);
    }

    @Override
    @NotNull
    protected Class<WindowCrafting> getWindowClass() {
        return WindowCrafting.class;
    }

    @NotNull
    public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull WindowCrafting containerScreen, double mouseX, double mouseY) {
        ArrayList<IGuiClickableArea> areas = new ArrayList<IGuiClickableArea>();
        JobBasedRecipeCategory<?> category = this.getRecipeCategory(containerScreen.getBuildingView());
        if (category != null) {
            areas.add(IGuiClickableArea.createBasic((int)90, (int)34, (int)22, (int)17, (ResourceLocation[])new ResourceLocation[]{category.getUid()}));
        }
        return areas;
    }

    @Override
    protected boolean isSupportedCraftingModule(@NotNull CraftingModuleView moduleView) {
        return moduleView.canLearn(ModCraftingTypes.SMALL_CRAFTING);
    }

    @Override
    protected boolean isSupportedSlot(@NotNull Slot slot) {
        return slot.field_75224_c instanceof CraftingInventory;
    }

    @Override
    protected void updateServer(@NotNull WindowCrafting gui) {
        HashMap<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
        CraftingInventory inventory = ((ContainerCrafting)gui.func_212873_a_()).getInv();
        if (gui.isCompleteCrafting()) {
            for (int i = 0; i < 9; ++i) {
                matrix.put(i, inventory.func_70301_a(i));
            }
        } else {
            matrix.put(0, inventory.func_70301_a(0));
            matrix.put(1, inventory.func_70301_a(1));
            matrix.put(3, inventory.func_70301_a(2));
            matrix.put(4, inventory.func_70301_a(3));
        }
        TransferRecipeCraftingTeachingMessage message = new TransferRecipeCraftingTeachingMessage(matrix, gui.isCompleteCrafting());
        Network.getNetwork().sendToServer(message);
    }
}

